<?php
/*
Plugin modification: DA1 / October 23rd 2005.
Integrated by: Doncho Angelov http://blog.doncho.net

Changes:
(*) Fixed SQL injection points
(*) Added code by Mike Baptiste (http://baptiste.us/), which allows
    pingbacks and trackbacks.
(*) Fixed PNG image generation, which caused the whole index.php to be
    append at the end of the generated PNG file. This caused some
    "header already sent" errors at some installations and also some
    incorrect displaying of the "secure image" at some circumstances.
*/
/*
Plugin Name: SecureImage
Plugin URI: http://uberdork.supertwist.net/download/secureimage.tar.gz
Description: This plugin inserts a text overlay image for the WP comment screen, requiring the poster to enter a valid code.  The original was created for 1.2 by Dave Fullard.  All bugs have been added by myself. This plugin requires ImageMagick's 'convert' utility.
Author: Thom Skrtich
Version: 1.0rc2.DA1
Author URI: http://uberdork.supertwist.net
*/
/*  Copyright 2005  Thom Skrtich  (email : bisohpthom@supertwist.net)
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/*
** This plugin was shamelessly lifed from Dave Fullard's blog  http://www.wellardsworld.com/
** The original version was setup for Wordpress 1.2.1 or 1.2.2.  Other features were even
** more shamelessly stolen from a dozen other programmers who are better at PHP than myself.
**  
** Given all of the new features and changes for 1.5, I figured it would be fun to packageize
** Dave's original script and put it out as a full fledged plug-in. This is my first attempt
** to write something for WordPress, please feel free to offer your feedback.
**
*/

//include something interesting here

if ( ! class_exists( 'SecureImage' ) ) :
class SecureImage {

  var $settings = array();
  var $table_version = 2;
  var $added_tables = false;

  function SecureImage ()
  {
    if (isset($this))
    {
      $this->settings = get_settings('secureimage');
      $this->register_tables();

      /* check and see how we were called */
      if(isset($_GET['image']))
      {
        /* we've been asked to serve up an image, outside of WP */
        //SecureImage::register_tables();
        global $wpdb;
        $image = mysql_real_escape_string($_GET['image']);
        header("Content-Type: image/png");
        die ($wpdb->get_var("SELECT img_data FROM $wpdb->secureimage WHERE img_name = '$image'"));
      }

      /* offer up the options menu */
      if (is_plugin_page()) {
         SecureImage::plugin_options();
      }

      add_action('admin_menu',   array(&$this, 'admin_menu'));
      add_action('comment_form', array(&$this, 'comment_form'));	//add image and input field to comment form
      add_action('comment_post', array(&$this, 'comment_post'));	//add post comment post security code check
      add_action('wp_head',      array(&$this, 'wp_head'));		//add post comment post security code check

  
      if ($this->settings['table_version'] != $this->table_version) {
        $this->drop_tables();
        $this->make_tables();
        $this->added_tables = true;
        update_option('secureimage', $this->settings);
      }
    }
      
  } //end constructor


  function register_tables()
  {
    global $wpdb, $table_prefix;
    $wpdb->secureimage = "{$table_prefix}secureimage";
  }

  function admin_menu()
  {
    if (function_exists('add_options_page')) {
      add_options_page('SecureImage', 'SecureImage', 8, basename(__FILE__));
    }
  }

  function plugin_options()
  {
    #if( isset( $_POST['update_options'] ) ) {
    if( $_POST['action'] == 'update' ) {
      $this->settings['convertpath'] = trim( $_POST['convertpath'] );
      $this->settings['fontfile'] = trim( $_POST['fontfile'] );
      $this->settings['validtime'] = trim( $_POST['validtime'] );
      $this->settings['lengthmin'] = trim( $_POST['lengthmin'] );
      $this->settings['lengthmax'] = trim( $_POST['lengthmax'] );
      $this->settings['sizemin'] = trim( $_POST['sizemin'] );
      $this->settings['sizemax'] = trim( $_POST['sizemax'] );
      $this->settings['blurmin'] = trim( $_POST['blurmin'] );
      $this->settings['blurmax'] = trim( $_POST['blurmax'] );
      $this->settings['anglemin'] = trim( $_POST['anglemin'] );
      $this->settings['anglemax'] = trim( $_POST['anglemax'] );
      $this->settings['swirlmin'] = trim( $_POST['swirlmin'] );
      $this->settings['swirlmax'] = trim( $_POST['swirlmax'] );
      $this->settings['wavemin'] = trim( $_POST['wavemin'] );
      $this->settings['wavemax'] = trim( $_POST['wavemax'] );

      update_option('secureimage', $this->settings);
      #echo '<div class="updated"><p><strong>' . __('Options updated.', 'secureimagedomain') . '</strong></p></div>';
      echo '<div class="updated"><p><strong>' . __('Options updated.') . '</strong></p></div>';
    }

    ?>

    <div class="wrap">
    <h2>SecureImage Options</h2>
    <p>SecureImage combines a variable length, random text string over multiple .png backgrounds in order to produce a random text code.
       The path to ImageMagick's 'convert' utility needs to be set below along with a preferred true-type font file to create the challenge.
       The minimum and maximum values below are used as limits for the random number function used to create each unique image. </p>

    <form name="secureoptions" method="post" >
      <input type="hidden" name="action" value="update" />
      <fieldset class="options">
      <table width="100%" cellspacing="2" cellpadding="5" class="editform">

      <tr>
      <th width="33%" valign="top" scope="row">Path to `convert` utility: </th>
      <td>
      <input name="convertpath" type="text" id="convertpath" value="<? echo $this->settings['convertpath']; ?>" size="50" /><br />
      <code>Recommended: /usr/bin/convert</code>
      </td>
      </tr>

      <tr>
      <tr>
      <th width="33%" valign="top" scope="row">Font (size min/max): </th>
      <td>
      <input name="fontfile" type="text" id="fontfile" value="<? echo $this->settings['fontfile']; ?>" size="37" />
      <input name="sizemin" type="text" id="sizemin" value="<? echo $this->settings['sizemin']; ?>" size="2" />
      <input name="sizemax" type="text" id="sizemax" value="<? echo $this->settings['sizemax']; ?>" size="2" /><br />
      <code>Recommended: FreeSansBold.ttf</code>
      </td>
      </tr>

      <tr>
      <th width="33%" valign="top" scope="row">Time to code expiration: </th>
      <td>
      <input name="validtime" type="text" id="validtime" value="<? echo $this->settings['validtime']; ?>" size="2" /> minutes<br /><br />
      </td>
      </tr>

      <tr><th>Randomization options:</th><td>(min / max)</td></tr>

      <tr>
      <th width="33%" valign="top" scope="row">Text: </th>
      <td>
      <input name="lengthmin" type="text" id="lengthmin" value="<? echo $this->settings['lengthmin']; ?>" size="2" />
      <input name="lengthmax" type="text" id="lengthmax" value="<? echo $this->settings['lengthmax']; ?>" size="2" /> length in characters
      </td>
      </tr>

      <tr>
      <th width="33%" valign="top" scope="row">Blur: </th>
      <td>
      <input name="blurmin" type="text" id="blurmin" value="<? echo $this->settings['blurmin']; ?>" size="2" />
      <input name="blurmax" type="text" id="blurmax" value="<? echo $this->settings['blurmax']; ?>" size="2" /> radius limit
      </td>
      </tr>

      <tr>
      <th width="33%" valign="top" scope="row">Angle: </th>
      <td>
      <input name="anglemin" type="text" id="anglemin" value="<? echo $this->settings['anglemin']; ?>" size="2" />
      <input name="anglemax" type="text" id="anglemax" value="<? echo $this->settings['anglemax']; ?>" size="2" /> limit in degrees
      </td>
      </tr>

      <tr>
      <th width="33%" valign="top" scope="row">Swirl: </th>
      <td>
      <input name="swirlmin" type="text" id="swirlmin" value="<? echo $this->settings['swirlmin']; ?>" size="2" />
      <input name="swirlmax" type="text" id="swirlmax" value="<? echo $this->settings['swirlmax']; ?>" size="2" /> limit in degrees
      </td>
      </tr>

      <tr>
      <th width="33%" valign="top" scope="row">Wave: </th>
      <td>
      <input name="wavemin" type="text" id="wavemin" value="<? echo $this->settings['wavemin']; ?>" size="2" />
      <input name="wavemax" type="text" id="wavemax" value="<? echo $this->settings['wavemax']; ?>" size="2" /> aplitutde limit
      </td>
      </tr>

      </table>
      </fieldset>

      <p class="submit"><input type="submit" name="Submit" value="Update Options &raquo;" /></p>

    </form>
    </div>

    <?php

  }


  function wp_head()
  {
    global $wpdb;
    // cleanup image records older than an hour
    $validdate = date('Y-m-d H:i:s', time() - ($this->settings['validtime'] * 60));
    $wpdb->query("DELETE from $wpdb->secureimage WHERE img_datetime < '$validdate'"); //clean up unused images
  }


  function comment_post($post_ID)    {
    global $wpdb, $user_ID;
    $securitycode = md5($_POST['securitycode']);
    $securityhash = mysql_real_escape_string($_POST['securityhash']);

    $validdate = date('Y-m-d H:i:s', time() - ($this->settings['validtime'] * 60));

    // If the user is not logged in check the security code
    if ( !$user_ID ) {
	// Grab the comment type from the database to ensure we only check comments
	// Is there anywhere the comment type can be found in a global var to save a DB check? I can.t find it.
	$comment_type = $wpdb->get_var("SELECT comment_type FROM $wpdb->comments WHERE comment_ID = $post_ID");
        // puke on an empty code
        if ($comment_type == '' || $comment_type == 'comment')	
	{
	    if ('' == $securitycode )
        	die( __('Error: please enter the security code.') );

    	    // verify the code against the database.
    	    if (!$wpdb->get_var("SELECT img_name FROM $wpdb->secureimage WHERE img_hash = '$securitycode' AND img_name= '$securityhash' AND img_datetime > '$validdate'")) 
	    {
		$safePostId = mysql_real_escape_string($post_ID);
        	$wpdb->query("DELETE from $wpdb->comments WHERE comment_ID = $post_ID"); //roll back the comment post
        	die('Invalid security code. Press your browsers back button and try again.');
    	    } 
	}
	$wpdb->query("DELETE from $wpdb->secureimage WHERE img_name= '$securityhash'"); //were ok, delete the image from db
    }

    return $post_ID;
  }


  function comment_form($post_ID) {
    global $wpdb, $user_ID;

    // If the user is logged in, dont prompt for code
    if (isset($user_ID))
        return $post_ID;

    $convertprg =  $this->settings['convertpath'];

    if (!file_exists($convertprg)) {
        die(_e('Couldn\'t find your convert utility. Check that you have ImageMagick installed.', 'SecureImage'));
    }

    //Generate the random string
    $chars = array("a","A","b","B","c","C","d","D","e","E","f","F","g","G","h","H","i","j","J",
                   "k","K","L","m","M","n","N","p","P","q","Q","r","R","s","S","t","T",
                   "u","U","v","V","w","W","x","X","y","Y","z","Z","1","2","3","4","5","6","7","8","9");
    $textstr = '';
    $imagestr = '';
    for ($i = 0, $length = rand($this->settings['lengthmin'], $this->settings['lengthmax']); $i < $length; $i++) {
         $textstr .= $chars[rand(0, count($chars) - 1)];
         $imagestr .= $chars[rand(0, count($chars) - 1)];
    }

    // SET SESSION VARIABLE
    $hashtext = md5($textstr);
    $imageName = md5($imagestr);
    //print $hashtext;

    # prep font and color
    $font = $this->settings['fontfile'];
    $color = sprintf("#%02X%02X%02X", rand(0,160), rand(0,160), rand(0,160));

    # image magick text gravities that we wanna use to position the text
    $gravities = array('West', 'Center', 'East');
    $gravity = $gravities[rand(0, count($gravities)-1)];

    # modify the image according to the generated settings
    $size =  rand($this->settings['sizemin'],  $this->settings['sizemax']);
    $blur =  rand($this->settings['blurmin'],  $this->settings['blurmax']);
    $angle = rand($this->settings['anglemin'], $this->settings['anglemax']);
    $swirl = rand($this->settings['swirlmin'], $this->settings['swirlmax']);
    $wave =  rand($this->settings['wavemin'],  $this->settings['wavemax']);

    # prepare our image magick command
    $cmd    = $convertprg;
    if (strlen($this->settings['fontfile'])>0) $cmd .= ' -font "'.$font.'"';
    $cmd .= ' -fill "'.$color.'"';
    $cmd .= ' -pointsize '.$size;
    $cmd .= ' -gravity "'.$gravity.'"';
    #$cmd .= ' -draw \'text 0,0 "'.$textstr.'"\''; #doesn't work under windoze
    $cmd .= ' -draw "text 0,0 \''.$textstr.'\'"';
    $cmd .= ' -blur '.$blur;
    $cmd .= ' -rotate '.$angle;
    $cmd .= ' -swirl '.$swirl;
    $cmd .= ' -wave '.$wave.'x80';
    $cmd .= ' - - '; # - - for stdin/stdout redirect
    #print $cmd;

    // -blur <radius>{x<sigma>}

    // build a template file descriptor set
    $descriptors = array(
         0 => array("pipe", "r"),    // stdin is a pipe that the child will read from
         1 => array("pipe", "w"),    // stdout is a pipe that the child will write to
         #2 => array("file", "php://stderr", "a") // stderr is a file to write to
    );

    $process = proc_open($cmd, $descriptors, $fd_set);
    if (is_resource($process)) {

        $bg = $this->get_background(rand(1,3));  // retrieve the background from the base64 imageset
        fwrite($fd_set[0], $bg);
        fclose($fd_set[0]);

        $fileContent = '';
        while($s = fgets($fd_set[1], 1024)) {
            // read from the pipe
            $fileContent .= $s;
        }
        fclose($fd_set[1]);

        // It is important that you close any pipes before calling
        // proc_close in order to avoid a deadlock
        proc_close($process);
        $fileContent = addslashes($fileContent);

        $sql = "INSERT INTO {$wpdb->secureimage} (img_name, img_hash, img_data, img_datetime) VALUES ('$imageName','$hashtext','$fileContent','".date('Y-m-d H:i:s')."');";
        $wpdb->query($sql);

        ?>
        <div style="display: left" id="secureimgdiv">
            <p>
            <input type="hidden" name="securityhash" id="securityhash" value="<?php echo $imageName;?>" /> 
            <input type="text" name="securitycode" id="securitycode" size="30" tabindex="4" />
	    
            <label for="securitycode"><strong>Security code [<img src="<?php echo $_SERVER[PHP_SELF];?>?image=<?php echo $imageName;?>" alt="Control image"/>]</strong></label>	    
	    </p>
        </div>

        <script language="JavaScript" type="text/javascript">
            var urlinput = document.getElementById("url");
            var submitp = urlinput.parentNode;
            var substitution2 = document.getElementById("secureimgdiv");
            submitp.appendChild(substitution2, urlinput);
        </script>

        <?php
    }

    return $post_ID;
  }

  function drop_tables() {
    global $wpdb, $table_prefix;
    if(!include_once(ABSPATH . 'wp-admin/upgrade-functions.php'))
        die(_e('There is was error removing the required tables from the database. ', 'SecureImage'));

    $wpdb->query('DROP TABLE IF EXISTS ' . $table_prefix . 'secureimage');
    dbDelta($sql);
  }

  function make_tables() {
    global $wpdb, $table_prefix;
    if(!include_once(ABSPATH . 'wp-admin/upgrade-functions.php'))
        die(_e('There is was error adding the required tables to the database. ', 'SecureImage'));

    $sql = "CREATE TABLE {$table_prefix}secureimage
            ( img_name varchar(32) default NULL,
	      img_hash varchar(32) default NULL,
              img_datetime datetime default NULL,
              img_data blob,
              KEY img_name (img_name)
            ) TYPE=MyISAM";

    dbDelta($sql);

    /* remember the current version */
    $this->settings['table_version'] = $this->table_version;

    /* set defaults */
    $this->settings['convertpath'] = "/usr/bin/convert";
    $this->settings['fontfile'] = "FreeSansBold.ttf";
    $this->settings['validtime'] = "10";
    $this->settings['lengthmin'] = "6";
    $this->settings['lengthmax'] = "9";
    $this->settings['sizemin'] = "24";
    $this->settings['sizemax'] = "36";
    $this->settings['blurmin'] = "1";
    $this->settings['blurmax'] = "5";
    $this->settings['anglemin'] = "-5";
    $this->settings['anglemax'] = "5";
    $this->settings['swirlmin'] = "10";
    $this->settings['swirlmax'] = "15";
    $this->settings['wavemin'] = "1";
    $this->settings['wavemax'] = "5";

    update_option('secureimage', $this->settings);

  }


  function get_background($bgval) {

  /*
  ** the following contains the three original secureimage backgrounds, base64 encoded.
  ** for simplicity. Since the combined images are stored in the db, why both managing
  ** external .png files.
  */
    $bg[1] = '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';
    $bg[2] = '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';
    $bg[3] = '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';

    $retval = base64_decode($bg[$bgval]);
    return $retval;
  }

  function include_up($filename)
  {
    $c=0;
    while(!is_file($filename))
    {
      $filename = '../' . $filename;
      $c++;
      if($c==30) {
        echo 'Could not find ' . basename($filename) . '.';
        return '';
      }
    }
    return $filename;
  }

}//end class
endif;

$secimg = new SecureImage();

?>
